using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using gov.va.med.vbecs.GUI.controls;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;


namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmPrintCautionTagByPatient
	/// </summary>
	public class FrmPrintCautionTagByPatient : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private ArrayList _cautionTags;
		private ArrayList _btrForms;

		private System.Windows.Forms.Panel pnlSelectPatient;
		private gov.va.med.vbecs.GUI.controls.PatientSelectTool patientSelectTool1;
		private System.Windows.Forms.Panel pnlPrintUnits;
		private System.Windows.Forms.GroupBox grpPrint;
		private System.Windows.Forms.PictureBox pictureBox1;
        private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.GroupBox grpUnits;
		private System.Windows.Forms.ListView lvUnits;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.CheckBox cbSearchByUnit;
		private System.Windows.Forms.Button btnCancelPatient;
		private System.Windows.Forms.Button btnCancelPrint;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnPrintTag;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnPrintForm;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnPrintBoth;
		private System.Windows.Forms.PrintDialog printDialog1;
		private System.Windows.Forms.Button btnCheckAll;
		private System.Windows.Forms.Button btnUncheckAll;
		private System.ComponentModel.IContainer components = null;

		// CR2899 start: caching objects
		string _units = null;
		private Hashtable _orderedUnitsCache = null;
		private Hashtable _orderedComponentsCache = null;
		private Hashtable _antNegsCache = null;
		private Hashtable _componentsCache = null;
		// CR2899 end

		// CR3119 start: indicates status of locking
		private bool _locksSucceeded;
        private PatientDisplayPanel patientDisplayPanel1;
		private bool _fromUC56;
		// CR3119 end

		#region constructors

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmPrintCautionTagByPatient()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();

			_cautionTags = new ArrayList();
			_btrForms = new ArrayList();
		}

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="patient"></param>
		/// <param name="bloodUnitGuids"></param>
		public FrmPrintCautionTagByPatient(BOL.Patient patient, ArrayList bloodUnitGuids)
		{
			_fromUC56 = true; // CR3119: need to know this for locking

			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();

			_cautionTags = new ArrayList();
			_btrForms = new ArrayList();

			this.pnlSelectPatient.Visible = false;
			this.pnlPrintUnits.Visible = true;
			this.patientDisplayPanel1.Patient = patient;
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC044.FrmPrintCautionTagByPatient());

			this.lvUnits.SuspendLayout();
			this.PopulateListView(bloodUnitGuids, patient);

			this.lvUnits.ResumeLayout();
		}

		#endregion


		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmPrintCautionTagByPatient));
            this.pnlSelectPatient = new System.Windows.Forms.Panel();
            this.cbSearchByUnit = new System.Windows.Forms.CheckBox();
            this.patientSelectTool1 = new gov.va.med.vbecs.GUI.controls.PatientSelectTool();
            this.btnCancelPatient = new System.Windows.Forms.Button();
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.pnlPrintUnits = new System.Windows.Forms.Panel();
            this.patientDisplayPanel1 = new gov.va.med.vbecs.GUI.controls.PatientDisplayPanel();
            this.btnPrintBoth = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.btnPrintForm = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.btnPrintTag = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.btnCancelPrint = new System.Windows.Forms.Button();
            this.grpUnits = new System.Windows.Forms.GroupBox();
            this.btnUncheckAll = new System.Windows.Forms.Button();
            this.btnCheckAll = new System.Windows.Forms.Button();
            this.lvUnits = new System.Windows.Forms.ListView();
            this.columnHeader1 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader2 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader3 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader4 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader5 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.grpPrint = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.printDialog1 = new System.Windows.Forms.PrintDialog();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.pnlSelectPatient.SuspendLayout();
            this.pnlPrintUnits.SuspendLayout();
            this.grpUnits.SuspendLayout();
            this.grpPrint.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(668, 30);
            this.vbecsLogo1.TabIndex = 2;
            this.vbecsLogo1.Title = "Print Unit Caution Tag and Transfusion Record Form";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.TabIndex = 3;
            // 
            // pnlSelectPatient
            // 
            this.pnlSelectPatient.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlSelectPatient.Controls.Add(this.cbSearchByUnit);
            this.pnlSelectPatient.Controls.Add(this.patientSelectTool1);
            this.pnlSelectPatient.Controls.Add(this.btnCancelPatient);
            this.pnlSelectPatient.Controls.Add(this.btnOK);
            this.pnlSelectPatient.Location = new System.Drawing.Point(0, 32);
            this.pnlSelectPatient.Name = "pnlSelectPatient";
            this.pnlSelectPatient.Size = new System.Drawing.Size(668, 440);
            this.pnlSelectPatient.TabIndex = 0;
            // 
            // cbSearchByUnit
            // 
            this.cbSearchByUnit.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.cbSearchByUnit.Location = new System.Drawing.Point(56, 396);
            this.cbSearchByUnit.Name = "cbSearchByUnit";
            this.cbSearchByUnit.Size = new System.Drawing.Size(104, 16);
            this.cbSearchByUnit.TabIndex = 1;
            this.cbSearchByUnit.Text = "Search by &Unit";
            this.cbSearchByUnit.CheckedChanged += new System.EventHandler(this.cbSearchByUnit_CheckedChanged);
            // 
            // patientSelectTool1
            // 
            this.patientSelectTool1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.patientSelectTool1.DisplaySIAndTRs = true;
            this.patientSelectTool1.EnabledBloodAvailButton = false;
            this.patientSelectTool1.EnabledMedicationButton = false;
            this.patientSelectTool1.EnabledRecentOrdersButton = false;
            this.patientSelectTool1.EnabledRecentTransfusionsIssuesButton = false;
            this.patientSelectTool1.EnabledSIAndTRButton = false;
            this.patientSelectTool1.EnabledTransfusionReactionHistoryButton = false;
            this.patientSelectTool1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.patientSelectTool1.Location = new System.Drawing.Point(0, 0);
            this.patientSelectTool1.Name = "patientSelectTool1";
            this.patientSelectTool1.SearchVistaLink = false;
            this.patientSelectTool1.Size = new System.Drawing.Size(668, 396);
            this.patientSelectTool1.TabIndex = 0;
            this.patientSelectTool1.PatientSelected += new System.EventHandler(this.patientSelectTool1_PatientSelected);
            this.patientSelectTool1.PatientDeselected += new System.EventHandler(this.patientSelectTool1_PatientDeselected);
            // 
            // btnCancelPatient
            // 
            this.btnCancelPatient.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancelPatient.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancelPatient.Location = new System.Drawing.Point(588, 412);
            this.btnCancelPatient.Name = "btnCancelPatient";
            this.btnCancelPatient.Size = new System.Drawing.Size(75, 23);
            this.btnCancelPatient.TabIndex = 3;
            this.btnCancelPatient.Text = "&Cancel";
            this.btnCancelPatient.Click += new System.EventHandler(this.btnCancelPatient_Click);
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.EnabledButton = false;
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = null;
            this.btnOK.Location = new System.Drawing.Point(508, 412);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 2;
            this.ttToolTip.SetToolTip(this.btnOK, "A patient must be selected");
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            // 
            // pnlPrintUnits
            // 
            this.pnlPrintUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlPrintUnits.Controls.Add(this.patientDisplayPanel1);
            this.pnlPrintUnits.Controls.Add(this.btnPrintBoth);
            this.pnlPrintUnits.Controls.Add(this.btnPrintForm);
            this.pnlPrintUnits.Controls.Add(this.btnPrintTag);
            this.pnlPrintUnits.Controls.Add(this.btnCancelPrint);
            this.pnlPrintUnits.Controls.Add(this.grpUnits);
            this.pnlPrintUnits.Controls.Add(this.grpPrint);
            this.pnlPrintUnits.Location = new System.Drawing.Point(0, 32);
            this.pnlPrintUnits.Name = "pnlPrintUnits";
            this.pnlPrintUnits.Size = new System.Drawing.Size(668, 440);
            this.pnlPrintUnits.TabIndex = 1;
            // 
            // patientDisplayPanel1
            // 
            this.patientDisplayPanel1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.patientDisplayPanel1.EnabledBloodAvailButton = false;
            this.patientDisplayPanel1.EnabledMedicationButton = false;
            this.patientDisplayPanel1.EnabledRecentOrdersButton = false;
            this.patientDisplayPanel1.EnabledRecentTransfusionsIssuesButton = false;
            this.patientDisplayPanel1.EnabledSIAndTRButton = false;
            this.patientDisplayPanel1.EnabledTransfusionReactionHistoryButton = false;
            this.patientDisplayPanel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.patientDisplayPanel1.Location = new System.Drawing.Point(4, 0);
            this.patientDisplayPanel1.Name = "patientDisplayPanel1";
            this.patientDisplayPanel1.Patient = null;
            this.patientDisplayPanel1.Size = new System.Drawing.Size(664, 40);
            this.patientDisplayPanel1.TabIndex = 7;
            // 
            // btnPrintBoth
            // 
            this.btnPrintBoth.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrintBoth.EnabledButton = false;
            this.btnPrintBoth.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnPrintBoth.Image = ((System.Drawing.Image)(resources.GetObject("btnPrintBoth.Image")));
            this.btnPrintBoth.Location = new System.Drawing.Point(476, 412);
            this.btnPrintBoth.Name = "btnPrintBoth";
            this.btnPrintBoth.Size = new System.Drawing.Size(100, 23);
            this.btnPrintBoth.TabIndex = 5;
            this.btnPrintBoth.Click += new System.EventHandler(this.btnPrintBoth_Click);
            // 
            // btnPrintForm
            // 
            this.btnPrintForm.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrintForm.EnabledButton = false;
            this.btnPrintForm.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnPrintForm.Image = ((System.Drawing.Image)(resources.GetObject("btnPrintForm.Image")));
            this.btnPrintForm.Location = new System.Drawing.Point(372, 412);
            this.btnPrintForm.Name = "btnPrintForm";
            this.btnPrintForm.Size = new System.Drawing.Size(100, 23);
            this.btnPrintForm.TabIndex = 4;
            this.btnPrintForm.Click += new System.EventHandler(this.btnPrintForm_Click);
            // 
            // btnPrintTag
            // 
            this.btnPrintTag.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrintTag.EnabledButton = false;
            this.btnPrintTag.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnPrintTag.Image = ((System.Drawing.Image)(resources.GetObject("btnPrintTag.Image")));
            this.btnPrintTag.Location = new System.Drawing.Point(268, 412);
            this.btnPrintTag.Name = "btnPrintTag";
            this.btnPrintTag.Size = new System.Drawing.Size(100, 23);
            this.btnPrintTag.TabIndex = 3;
            this.btnPrintTag.Click += new System.EventHandler(this.btnPrintTag_Click);
            // 
            // btnCancelPrint
            // 
            this.btnCancelPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancelPrint.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancelPrint.Location = new System.Drawing.Point(588, 412);
            this.btnCancelPrint.Name = "btnCancelPrint";
            this.btnCancelPrint.Size = new System.Drawing.Size(75, 23);
            this.btnCancelPrint.TabIndex = 6;
            this.btnCancelPrint.Text = "&Cancel";
            this.btnCancelPrint.Click += new System.EventHandler(this.btnCancelPatient_Click);
            // 
            // grpUnits
            // 
            this.grpUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpUnits.Controls.Add(this.btnUncheckAll);
            this.grpUnits.Controls.Add(this.btnCheckAll);
            this.grpUnits.Controls.Add(this.lvUnits);
            this.grpUnits.Location = new System.Drawing.Point(48, 44);
            this.grpUnits.Name = "grpUnits";
            this.grpUnits.Size = new System.Drawing.Size(616, 364);
            this.grpUnits.TabIndex = 2;
            this.grpUnits.TabStop = false;
            this.grpUnits.Text = "Select Unit(s) to Print*";
            // 
            // btnUncheckAll
            // 
            this.btnUncheckAll.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnUncheckAll.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.btnUncheckAll.Image = ((System.Drawing.Image)(resources.GetObject("btnUncheckAll.Image")));
            this.btnUncheckAll.Location = new System.Drawing.Point(568, 0);
            this.btnUncheckAll.Name = "btnUncheckAll";
            this.btnUncheckAll.Size = new System.Drawing.Size(16, 16);
            this.btnUncheckAll.TabIndex = 18;
            this.btnUncheckAll.Click += new System.EventHandler(this.btnUncheckAll_Click);
            // 
            // btnCheckAll
            // 
            this.btnCheckAll.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCheckAll.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.btnCheckAll.Image = ((System.Drawing.Image)(resources.GetObject("btnCheckAll.Image")));
            this.btnCheckAll.Location = new System.Drawing.Point(584, 0);
            this.btnCheckAll.Name = "btnCheckAll";
            this.btnCheckAll.Size = new System.Drawing.Size(16, 16);
            this.btnCheckAll.TabIndex = 17;
            this.btnCheckAll.Click += new System.EventHandler(this.btnCheckAll_Click);
            // 
            // lvUnits
            // 
            this.lvUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvUnits.CheckBoxes = true;
            this.lvUnits.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader1,
            this.columnHeader2,
            this.columnHeader3,
            this.columnHeader4,
            this.columnHeader5});
            this.lvUnits.FullRowSelect = true;
            this.lvUnits.Location = new System.Drawing.Point(8, 16);
            this.lvUnits.MultiSelect = false;
            this.lvUnits.Name = "lvUnits";
            this.lvUnits.Size = new System.Drawing.Size(600, 340);
            this.lvUnits.TabIndex = 0;
            this.lvUnits.UseCompatibleStateImageBehavior = false;
            this.lvUnits.View = System.Windows.Forms.View.Details;
            this.lvUnits.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvUnits_ColumnClick);
            this.lvUnits.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvUnits_ItemCheck);
            this.lvUnits.SelectedIndexChanged += new System.EventHandler(this.lvUnits_SelectedIndexChanged);
            // 
            // columnHeader1
            // 
            this.columnHeader1.Text = "";
            this.columnHeader1.Width = 25;
            // 
            // columnHeader2
            // 
            this.columnHeader2.Text = "Unit ID";
            this.columnHeader2.Width = 150;
            // 
            // columnHeader3
            // 
            this.columnHeader3.Text = "Product";
            this.columnHeader3.Width = 100;
            // 
            // columnHeader4
            // 
            this.columnHeader4.Text = "ABO/Rh";
            this.columnHeader4.Width = 100;
            // 
            // columnHeader5
            // 
            this.columnHeader5.Text = "Expiration Date";
            this.columnHeader5.Width = 140;
            // 
            // grpPrint
            // 
            this.grpPrint.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpPrint.Controls.Add(this.pictureBox1);
            this.grpPrint.Location = new System.Drawing.Point(4, 44);
            this.grpPrint.Name = "grpPrint";
            this.grpPrint.Size = new System.Drawing.Size(40, 364);
            this.grpPrint.TabIndex = 1;
            this.grpPrint.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 12);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(32, 32);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
            this.pictureBox1.TabIndex = 0;
            this.pictureBox1.TabStop = false;
            // 
            // FrmPrintCautionTagByPatient
            // 
            this.AcceptButton = this.btnOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancelPrint;
            this.ClientSize = new System.Drawing.Size(668, 473);
            this.Controls.Add(this.pnlPrintUnits);
            this.Controls.Add(this.pnlSelectPatient);
            this.hlphelpChm.SetHelpKeyword(this, "Print_Unit_Caution_Tag_&_Transfusion_Record_Form.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(676, 500);
            this.Name = "FrmPrintCautionTagByPatient";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Print Unit Caution Tag and Transfusion Record Form";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmPrintCautionTagByPatient_KeyDownSpeakMessage);
            this.Controls.SetChildIndex(this.pnlSelectPatient, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.pnlPrintUnits, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.pnlSelectPatient.ResumeLayout(false);
            this.pnlPrintUnits.ResumeLayout(false);
            this.grpUnits.ResumeLayout(false);
            this.grpPrint.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion


		#region properties

		/// <summary>
		/// CR3119
		/// This indicates whether locking was successful. It is used by the calling form to see 
		/// whether launching this one should continue.
		/// </summary>
		public bool IsValid
		{
			get
			{
				return _locksSucceeded;
			}
		}

		#endregion


		#region methods

		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC044.FrmPrintCautionTagByPatient());
			this.pnlSelectPatient.Visible = true;
			this.pnlPrintUnits.Visible = false;
			this.btnOK.EnabledButton = false;

			this.btnPrintTag.Text = "Print &Tag";
			this.btnPrintForm.Text = "Print &Form";
			this.btnPrintBoth.Text = "Print &Both";

			this.btnPrintTag.SetToolTip(Common.StrRes.Tooltips.UC043.ChooseUnit().ResString);
			this.btnPrintForm.SetToolTip(Common.StrRes.Tooltips.UC043.ChooseUnit().ResString);
			this.btnPrintBoth.SetToolTip(Common.StrRes.Tooltips.UC043.ChooseUnit().ResString);

			//CR2899: added for locking support
			this.LockController.LockFunction = Common.LockFunctions.UC043PrintUnitCautionTag;
		}



		// CR2899 start: retrieval of cache objects
		private void GetUnitsString(ArrayList bloodUnits)
		{
			StringBuilder sb = new StringBuilder();
			for (int i=0; i<bloodUnits.Count; i++)
			{
				if (i > 0) sb.Append(",");

				sb.Append( ( (BOL.BloodUnit) bloodUnits[i] ).BloodUnitGuid.ToString() );
			}
			_units = sb.ToString();
		}
		// CR2899 end


		// CR2899 start: get cache data		
		private void GetCacheData(ArrayList bloodUnits, BOL.Patient patient)
		{
			_orderedUnitsCache = new Hashtable();
			_orderedComponentsCache = new Hashtable();

			if (_units == null) GetUnitsString(bloodUnits);
				
			DataTable dtOrderedUnits = BOL.OrderedUnit.GetOrderedUnitData(_units, patient.PatientGuid);
			for (int i=0; i<dtOrderedUnits.Rows.Count; i++)
			{
				BOL.OrderedUnit ou = new BOL.OrderedUnit(dtOrderedUnits.Rows[i]);
				_orderedUnitsCache.Add(ou.BloodUnitGuid, ou);

				if (!_orderedComponentsCache.ContainsKey(ou.OrderedComponentGuid))
				{
					BOL.OrderedComponent oc =  new BOL.OrderedComponent( BOL.OrderedComponent.GetOrderedComponent(ou.OrderedComponentGuid).Rows[0] ); 
					_orderedComponentsCache.Add(oc.OrderedComponentGuid, oc);
				}
			}

			GetAntNegsAndComponents(bloodUnits, patient);

			GenerateLocks();
		}
		// CR2899 end


		// CR2899: new locking
		private void GenerateLocks()
		{
			// OrderedUnits			
			IDictionaryEnumerator ouEnum = _orderedUnitsCache.GetEnumerator();
			while (ouEnum.MoveNext())
			{
                //CR3317 - changed locks from being collected in ArrayList to the RecordGuids property
                this.LockController.RecordGuids.Add(((BOL.OrderedUnit)ouEnum.Value).OrderedUnitGuid);
			}

			IDictionaryEnumerator ocEnum = _orderedComponentsCache.GetEnumerator();
			while (ocEnum.MoveNext())
			{
				BOL.OrderedComponent oc = (BOL.OrderedComponent) ocEnum.Value;
				if (oc.SpecimenIdentified)  // CR3114
				{
					Guid specimenGuid = oc.GetSpecimen().SpecimenGuid;  // CR3114
                    if (!this.LockController.RecordGuids.Contains(specimenGuid))        //CR3317 updated to use new RecordGuids property
					{
                        this.LockController.RecordGuids.Add(specimenGuid);
					}
				}
			}

			if (!this.SetLocks())
			{
				if (!_fromUC56)
				{
					this.Close();
				}
				_locksSucceeded = false;
				return; 
			}
			_locksSucceeded = true;
		}
		// CR2899 end



		// CR2899 start: retrieval of antigen/component cache objects
		private void GetAntNegsAndComponents(ArrayList bloodUnits, BOL.Patient patient)
		{
			_antNegsCache = patient.ValidateAntibodyAntigenRequirementsMet(bloodUnits);
			_componentsCache = patient.ValidateComponentRequirements(bloodUnits);
		}
		// CR2899 end



		private void PopulateListView(BOL.Patient patient)
		{
			ArrayList displayItems = BOL.CautionTag.GetUnitsForDisplay(patientSelectTool1.SelectedPatient.PatientGuid);
			// CR2899: collection for getting batch data
			ArrayList bloodUnits = new ArrayList(displayItems.Count);
		
			foreach (Hashtable ht in displayItems)
			{
				BOL.BloodUnit bloodUnit = new BOL.BloodUnit( (Guid) ht[Common.VbecsTables.BloodUnit.BloodUnitGuid] ); 
				bloodUnits.Add(bloodUnit); // CR2899

				ListViewItem lVI = new ListViewItem();
				lVI.Tag = bloodUnit;
				lVI.SubItems.Add(ht[Common.VbecsTables.BloodUnit.EyeReadableUnitId].ToString() );
				lVI.SubItems.Add(ht[Common.VbecsTables.BloodProduct.ProductShortName].ToString()+", "+bloodUnit.FullProductCode);
				lVI.SubItems.Add(ht[Common.DatabaseConstants.ArtificialColumnNames.ABORh].ToString() );
				lVI.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(ht[Common.VbecsTables.BloodUnitMedia.UnitExpirationDate].ToString()));
				this.lvUnits.Items.Add(lVI);
			}
			//
			controls.VbecsFunction.SetColumnWidths(lvUnits);

			// CR2899: populate cache tables
			GetCacheData(bloodUnits, patient);
		}



		// CR2899 start: The check to see if its OK to print tags has been eliminated, resulting in
		// HUGE performance gains.  Oh yeah!
		private void PopulateListView(ArrayList bloodUnitGuids, BOL.Patient patient)
		{			
			// CR2899: collection for getting batch data
			ArrayList bloodUnits = new ArrayList(bloodUnitGuids.Count);

			for (int i=0; i<bloodUnitGuids.Count; i++)
			{
				BOL.BloodUnit bloodUnit = new BOL.BloodUnit( (Guid) bloodUnitGuids[i]);
				bloodUnits.Add(bloodUnit); // CR2899

				// Units could come in here in an issued status.
				if (bloodUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Issued) continue;
				ListViewItem lVI = new ListViewItem();
				lVI.Tag = bloodUnit;
				lVI.SubItems.Add(bloodUnit.EyeReadableUnitId);
				lVI.SubItems.Add(bloodUnit.ProductShortName+", "+bloodUnit.FullProductCode);
				lVI.SubItems.Add(bloodUnit.BloodUnitMedia.AboRh.AboRHText);
				lVI.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(bloodUnit.BloodUnitMedia.UnitExpirationDate.ToString()));	
				this.lvUnits.Items.Add(lVI);
			}
			//
			controls.VbecsFunction.SetColumnWidths(lvUnits);

			// CR2899: populate cache tables
			GetCacheData(bloodUnits, patient);
		}

		private bool PrintBtrf(BOL.CautionTag cautionTag, System.Drawing.Printing.PrinterSettings settings)
		{
			if (!cautionTag.GenerateExceptionReport()) return false;

			// BR_43.13
			if (!Common.LogonUser.PrintedTags.ContainsKey(cautionTag.BloodUnit.BloodUnitGuid))
			{	
				Common.LogonUser.PrintedTags.Add(cautionTag.BloodUnit.BloodUnitGuid, cautionTag.Patient.PatientGuid);
			}

            ReportDataSource reportSourceMain = new ReportDataSource();
            reportSourceMain.Name = "BTRFDataSet";
            reportSourceMain.Value = cautionTag.GetBtrfDataSet().Tables[0];

            Assembly assembly = Assembly.LoadFrom("Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.BloodTransfusionRecordForm.BloodTransfusionRecordForm.rdlc");

            LocalReport report = new LocalReport();
            report.DataSources.Add(reportSourceMain);
            report.LoadReportDefinition(stream);
            report.DisplayName = "BTRF";

		    using (var reportPrinter = new BOL.VbecsReportPrinter(settings.PrinterName, false, report))
		    {
		        reportPrinter.Print();
		    }
		    return true;
		}


		// CR22899 start
		/// <summary>
		/// SetCheckState
		/// </summary>
		private void SetCheckState(bool isChecked)
		{
			int itemCount = this.lvUnits.Items.Count;
			//
			if(itemCount > 0)
			{
				for (int idx = 0; idx < itemCount; idx++)
				{
					this.lvUnits.Items[idx].Checked = isChecked;
				}
			}
		}
		// CR2899 end

		#endregion


		#region events

		/// <summary>
		/// Print the Caution Tag(s)
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnPrintTag_Click(object sender, System.EventArgs e)
		{
			int tagsPrintedCounter = 0;
			foreach (BOL.CautionTag cautionTag in _cautionTags)
			{
				if (Common.LogonUser.PrintThreadCT != null && Common.LogonUser.PrintThreadCT.IsAlive && cautionTag.EmergencyIssue)
				{
					Common.LogonUser.PrintThreadCT.Abort();
				}
		
				// blocking until printer becomes available
				while (Common.LogonUser.PrintThreadCT != null && Common.LogonUser.PrintThreadCT.IsAlive);


				try
				{
					if (cautionTag.Print(Common.Print.CautionTag)) 
					{
						// If the messages get sent in rapid succession, the printer will drop them.
						Thread.Sleep(2000);
						tagsPrintedCounter++;
						continue;
					}
					else 
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC043.PrinterProblem());
						break;
					}
				}
				catch (System.Net.Sockets.SocketException)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC003.CautionTagPrinterNotAvailable());
					break;
				}
				catch (BOL.BusinessObjectException)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC043.LabelPrinterNotConfigured());
					break;
				}
			}
			if (_cautionTags.Count == tagsPrintedCounter)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC043.PrintSuccess());
			}
		}

		/// <summary>
		/// Print the Blood Transfusion Record Form(s)
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnPrintForm_Click(object sender, System.EventArgs e)
		{
			System.Drawing.Printing.PrinterSettings settings = new System.Drawing.Printing.PrinterSettings();
			printDialog1.PrinterSettings = settings;

			if (printDialog1.ShowDialog(this) == DialogResult.OK)
			{
				foreach (BOL.CautionTag cautionTag in _cautionTags)
				{
					if (Common.LogonUser.PrintThreadBTRF != null && Common.LogonUser.PrintThreadBTRF.IsAlive && cautionTag.EmergencyIssue)
					{
						Common.LogonUser.PrintThreadBTRF.Abort();
					}

					// blocking until printer becomes available
					while (Common.LogonUser.PrintThreadBTRF != null && Common.LogonUser.PrintThreadBTRF.IsAlive);
				
					if (!PrintBtrf(cautionTag, settings))
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC043.PrinterProblem());
					}	
				}
				GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC043.PrintSuccess());
			}
		}

		private void btnPrintBoth_Click(object sender, System.EventArgs e)
		{
			foreach (BOL.CautionTag cautionTag in _cautionTags)
			{
				if (Common.LogonUser.PrintThreadCT != null && Common.LogonUser.PrintThreadCT.IsAlive && cautionTag.EmergencyIssue)
				{
					Common.LogonUser.PrintThreadCT.Abort();
				}
				if (Common.LogonUser.PrintThreadBTRF != null && Common.LogonUser.PrintThreadBTRF.IsAlive && cautionTag.EmergencyIssue)
				{
					Common.LogonUser.PrintThreadBTRF.Abort();
				}

				// blocking until printer becomes available
				while (Common.LogonUser.PrintThreadCT != null && Common.LogonUser.PrintThreadCT.IsAlive &&
					Common.LogonUser.PrintThreadBTRF != null && Common.LogonUser.PrintThreadBTRF.IsAlive);

				try
				{
					if (cautionTag.Print(Common.Print.CautionTag))
					{
						Thread.Sleep(2000);
					}
					else 
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC043.PrinterProblem());
						break;
					}
				}
				catch(BOL.BusinessObjectException)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC003.CautionTagPrinterNotAvailable());
					break;
				}
				catch (System.Net.Sockets.SocketException)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC003.CautionTagPrinterNotAvailable());
					break;
				}
			}

			
			System.Drawing.Printing.PrinterSettings settings = new System.Drawing.Printing.PrinterSettings();
			printDialog1.PrinterSettings = settings;

			if (printDialog1.ShowDialog(this) == DialogResult.OK)
			{
				foreach (BOL.CautionTag btrForm in _cautionTags)
				{
					if (!PrintBtrf(btrForm, settings))
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC043.PrinterProblem());
					}
				}
			}
			GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC043.PrintSuccess());
		}

		/// <summary>
		/// Hide the patient panel and show the unit selection panel
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.pnlSelectPatient.Visible = false;
			this.pnlPrintUnits.Visible = true;
			this.patientDisplayPanel1.Patient = this.patientSelectTool1.SelectedPatient; 
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC044.FrmPrintCautionTagByPatient());
			
			PopulateListView(this.patientDisplayPanel1.Patient);
		}

		private void btnCancelPatient_Click(object sender, System.EventArgs e)
		{

#if DEBUG
			//			dsPrint.WriteXml(@"C:\Foodataset.xml", System.Data.XmlWriteMode.WriteSchema);
#endif
		
			this.Close();
		}

		private void patientSelectTool1_PatientSelected(object sender, System.EventArgs e)
		{
			bool units = BOL.CautionTag.VerifyPatientHasUnits(patientSelectTool1.SelectedPatient.PatientGuid);
			if (units) 
			{
				this.btnOK.EnabledButton = true;
				this.ttToolTip.SetToolTip(this.btnOK, string.Empty);
			}
			else
			{
				this.btnOK.EnabledButton = false;
				this.ttToolTip.SetToolTip(this.btnOK, Common.StrRes.Tooltips.UC043.NoUnits().ResString);
			}
		}

		private void patientSelectTool1_PatientDeselected(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = false;
			this.ttToolTip.SetToolTip(this.btnOK, Common.StrRes.Tooltips.UC043.NoPatient().ResString);
		}

		private void cbSearchByUnit_CheckedChanged(object sender, System.EventArgs e)
		{
			FrmPrintCautionTagByUnit frm = new FrmPrintCautionTagByUnit();
			frm.Show();
			this.Close();
		}

		private void lvUnits_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			bool setLocks = false;
			lvUnits.Enabled = false;
			BOL.BloodUnit bloodUnit = (BOL.BloodUnit) lvUnits.Items[e.Index].Tag;

			if (e.NewValue == CheckState.Checked)
			{
				BOL.OrderedUnit ou = (BOL.OrderedUnit) _orderedUnitsCache[bloodUnit.BloodUnitGuid];
				// CR2899: parameters for batch processing
				BOL.CautionTag cautionTag = new BOL.CautionTag(bloodUnit, 
					this.patientDisplayPanel1.Patient, 
					ThisUser, 
					false,
					(BOL.OrderedComponent) _orderedComponentsCache[ ou.OrderedComponentGuid],
					ou,
					_antNegsCache,
					_componentsCache);
				
				// Everything is perfect, print the tags!!!!
				if (!cautionTag.OverrideRequired && cautionTag.PrintOK == true && cautionTag.Message.Length == 0)
				{
					// CR2899
					setLocks = this.SetLocks(bloodUnit.BloodUnitStatus.BloodUnitStatusGuid);
					if(setLocks)
					{
						_cautionTags.Add(cautionTag);
					}
				}
				else
				{
					// Tag CANNOT be printed
					if (!cautionTag.PrintOK)
					{
						if (cautionTag.Beep) GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(Common.StrRes.InfoMsg.UC043.InvalidUnit("\n\nUnit: " + bloodUnit.EyeReadableUnitId + "\n\n" + cautionTag.Message + "\n").ResString));
						else GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC043.InvalidUnit("\n\nUnit: " + bloodUnit.EyeReadableUnitId + "\n\n" + cautionTag.Message + "\n"));
						e.NewValue = CheckState.Unchecked;
					}
					else
					{
						// Tag can be printed with an override
						if (cautionTag.OverrideRequired)
						{
							DialogResult result = GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC043.Warnings("\n\nUnit: " + bloodUnit.EyeReadableUnitId + "\n\n" + cautionTag.Message + "\n"));

							if (result == DialogResult.OK)
							{
								// Get override comment
								DlgOverrideComment dlg = new DlgOverrideComment("VBECS - Comment is needed", "Please enter a comment to override warnings", "UI", Common.StrRes.HelpFiles.UC044.FrmPrintCautionTagByPatient().ResString);
								dlg.ShowDialogFromLockedParent(this,false);	 //COuld be OK w/o Special Lock method, but dont hurt?
								if (dlg.DialogResult == DialogResult.OK)
								{
									cautionTag.OverrideComment = dlg.Comment;
									
									// CR2899
									setLocks = this.SetLocks(bloodUnit.BloodUnitStatus.BloodUnitStatusGuid);
									if(setLocks)
									{
										_cautionTags.Add(cautionTag);
									}
									// CR3137: Lock failed, so uncheck it
									else
									{
										e.NewValue = CheckState.Unchecked;
									}
								}
								// No override, so uncheck it
								else
								{
									e.NewValue = CheckState.Unchecked;
								}
							}
							// No override, so uncheck it
							else
							{
								e.NewValue = CheckState.Unchecked;
							}
						}
						else
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC043.Informational("\n\n" + cautionTag.Message + "\n"));
							// CR3137
							setLocks = this.SetLocks(bloodUnit.BloodUnitStatus.BloodUnitStatusGuid);
							if(setLocks)
							{
								_cautionTags.Add(cautionTag);
							}
							else
							{
								e.NewValue = CheckState.Unchecked;
							}
							// CR3137 end
						}
					}
				}
			}
			else
			{
				foreach (BOL.CautionTag cautionTag in this._cautionTags)
				{
					if (cautionTag.BloodUnit == bloodUnit)
					{
						_cautionTags.Remove(cautionTag);
						// CR2899
						this.ReleaseLocks(cautionTag.BloodUnit.BloodUnitStatus.BloodUnitStatusGuid);
						break;
					}
				}
	
			}
			lvUnits.Enabled = true;
			// CR2899
			if(!setLocks)
			{
				e.NewValue = CheckState.Unchecked;
				foreach (BOL.CautionTag cautionTag in this._cautionTags)
				{
					if (cautionTag.BloodUnit == bloodUnit)
					{
						_cautionTags.Remove(cautionTag);
						// CR2899
						this.ReleaseLocks(cautionTag.BloodUnit.BloodUnitStatus.BloodUnitStatusGuid);
						break;
					}
				}
			}
			
			EnableDisableButtons(e.NewValue == CheckState.Checked || _cautionTags.Count > 0);
		}




		/// <summary>
		/// Enables or disables all of the print buttons and sets the tooltips
		/// </summary>
		/// <param name="enable"></param>
		private void EnableDisableButtons(bool enable)
		{
			this.btnPrintTag.EnabledButton = enable;
			this.btnPrintForm.EnabledButton = enable;
			this.btnPrintBoth.EnabledButton = enable;
			if (enable)
			{
				this.btnPrintTag.SetToolTip(string.Empty);
				this.btnPrintForm.SetToolTip(string.Empty);
				this.btnPrintBoth.SetToolTip(string.Empty);
			}
			else
			{
				this.btnPrintTag.SetToolTip(Common.StrRes.Tooltips.UC043.ChooseUnit().ResString);
				this.btnPrintForm.SetToolTip(Common.StrRes.Tooltips.UC043.ChooseUnit().ResString);
				this.btnPrintBoth.SetToolTip(Common.StrRes.Tooltips.UC043.ChooseUnit().ResString);
			}
		}

		private void lvUnits_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == this.lvUnits.Columns.IndexOf(this.columnHeader5))
			{
				ColumnClickSorter.ColumnClickHandler(sender, e, lvUnits.CheckBoxes, ColumnClickSorter.ColumnSortType.DateTime);
			}
			else 
			{
				ColumnClickSorter.ColumnClickHandler(sender, e, lvUnits.CheckBoxes, ColumnClickSorter.ColumnSortType.String);
			}
		}

		#endregion
		
		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmPrintCautionTagByPatient_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if (this.pnlSelectPatient.Visible)
			{
				textToSpeak = this.patientSelectTool1.GetErrorMessagesFor508();

				if (this.btnOK.EnabledButton == false)
				{
					textToSpeak += "\n";
					textToSpeak += this.ttToolTip.GetToolTip(this.btnOK);
				}
			}
			else
			{
				if (this.btnPrintBoth.EnabledButton == false)
				{
					if (textToSpeak != "")
						textToSpeak += "\n";
					if (textToSpeak.IndexOf(this.btnPrintBoth.GetToolTip()) == -1)
						textToSpeak += this.btnPrintBoth.GetToolTip();
				}

				if (this.btnPrintForm.EnabledButton == false)
				{
					if (textToSpeak != "")
						textToSpeak += "\n";
					if (textToSpeak.IndexOf(this.btnPrintForm.GetToolTip()) == -1)
						textToSpeak += this.btnPrintForm.GetToolTip();
				}

				if (this.btnPrintTag.EnabledButton == false)
				{
					if (textToSpeak != "")
						textToSpeak += "\n";
					if (textToSpeak.IndexOf(this.btnPrintTag.GetToolTip()) == -1)
						textToSpeak += this.btnPrintTag.GetToolTip();
				}
			}
			if(this.patientDisplayPanel1.Visible)
			{
				textToSpeak = string.Concat(textToSpeak, this.patientDisplayPanel1.GetErrorMessagesFor508());
			}

			this.SpeakMessage( textToSpeak );		
		}

		private void lvUnits_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.SpeakListViewWithCheckBox(lvUnits);
		}

		// CR2899 start
		/// <summary>
		/// Deselect all units
		/// </summary>
		private void btnUncheckAll_Click(object sender, System.EventArgs e)
		{
			SetCheckState(false);
		}


		/// <summary>
		/// Select all units
		/// </summary>
		private void btnCheckAll_Click(object sender, System.EventArgs e)
		{
			SetCheckState(true);
		}
		// CR2899 end
	}
}

